DECLARE SUB SENDCTRLC ()
DECLARE SUB SENDCMD (SCA$)
DECLARE SUB DELAY (DELN!)
DECLARE SUB ECHOWAIT ()
PRINT
PRINT "*** CAPTURE 1.2 ***  04/98  Stephen Shefsky  DURRIDGE Co."
PRINT

REM  Compile with Microsoft QuickBASIC 4.5

CLINE$ = COMMAND$
DIM ARG$(10)
GOSUB ARGSPLIT
IF ARG$(1) = "" THEN ARG$(1) = "DURRIDGE.DAT"
IF ARG$(2) = "" THEN PORT$ = "COM1" ELSE PORT$ = LEFT$(ARG$(2), 4)
WHILE LEFT$(PORT$, 3) <> "COM"
	INPUT "No COM port specified.  Please give port number: COM", A
	IF A = 1 THEN PORT$ = "COM1"
	IF A = 2 THEN PORT$ = "COM2"
	IF A = 3 THEN PORT$ = "COM3"
	IF A = 4 THEN PORT$ = "COM4"
WEND

OPEN PORT$ + ":1200,N,8,1,RS,CS0,DS0,CD0,BIN" FOR RANDOM AS #1
PRINT "Communication port "; PORT$; " is open."
OPEN ARG$(1) FOR OUTPUT AS #2
PRINT "Output file "; ARG$(1); " is open."
PRINT
PRINT "Begin data transfer now.  Press (Q) key to quit or abort."
REM CALL SENDCMD("DATA COM 3")

T1 = TIMER + 30                        '30 seconds to time out
WHILE LOC(1) = 0                       'Wait for a byte to arrive
	A$ = INKEY$                         'Check for keystroke
	IF A$ = "Q" OR A$ = "q" THEN        'If Q key, then abort
		CLOSE #1: CLOSE #2
		PRINT "Transfer aborted."        'Inform user
		BEEP
		SYSTEM                           'Transfer control to DOS
	ELSE
		IF LEN(A$) <> 0 THEN
			PRINT #1, A$;
			CALL ECHOWAIT
			T1 = TIMER + 30
		END IF
	END IF
	IF TIMER > T1 THEN                  'If timed out, then quit
		CLOSE #1: CLOSE #2
		PRINT "Timed out."               'Tell user
		BEEP
		SYSTEM                           'Transfer control to DOS
	END IF
WEND                                   'If no byte, keep fishing
T1 = TIMER + 2                         'Now use 2 sec. timeout
WHILE TIMER < T1                       'Timeout ends transfer
	WHILE LOC(1) <> 0                   'Get bytes
		A$ = INPUT$(1, #1)               'Read in byte
		PRINT #2, A$;                    'Put byte to output file
		PRINT A$;                        'Print it as ASCII character
		T1 = TIMER + 2                   'Reset T1 after byte comes in
	WEND                                'Get more bytes, if arrived
	A$ = INKEY$                         'Check for keystroke
	IF A$ = "Q" OR A$ = "q" THEN        'If Q key then quit
		CLOSE #1: CLOSE #2
		PRINT "Transfer aborted."        'Tell user
		BEEP
		SYSTEM                           'Return to DOS
	END IF
WEND                                   'Look for timeout
CLOSE #1: CLOSE #2                     'End of transfer
PRINT "Transfer finished."             'Let user know
BEEP
SYSTEM                                 'Return to DOS


ARGSPLIT:
	TRUE = -1
	FALSE = 0
	I = 1
	N = 1
	INWORD = TRUE
	WHILE I <= LEN(CLINE$) AND N < 10
		CH$ = MID$(CLINE$, I, 1)
		IF CH$ <> " " THEN
			IF NOT INWORD THEN INWORD = TRUE
			ARG$(N) = ARG$(N) + CH$
		ELSEIF INWORD THEN
			N = N + 1
			INWORD = FALSE
		END IF
		I = I + 1
	WEND
RETURN

SUB DELAY (DELN)
	TIM = TIMER
	WHILE TIMER < (TIM + .01 * DELN)
		 REM DO NOTHING
	WEND
END SUB

SUB ECHOWAIT
	WHILE LOC(1) = 0
		EWA = EWA
	WEND
	WHILE LOC(1) > 0
		WHILE LOC(1) > 0
			EWIN$ = INPUT$(1, #1)
			PRINT EWIN$;
		WEND
		CALL DELAY(2)
	WEND
END SUB

SUB SENDCMD (SCA$)
	CALL SENDCTRLC
	WHILE LEN(SCA$) > 0
		PRINT #1, LEFT$(SCA$, 1);
		SCA$ = RIGHT$(SCA$, LEN(SCA$) - 1)
		CALL ECHOWAIT
	WEND
	PRINT #1, CHR$(13);
	CALL DELAY(50)
	WHILE LOC(1) > 0
		WHILE LOC(1) > 0
			SCIN$ = INPUT$(1, #1)
			PRINT SCIN$;
		WEND
		CALL DELAY(2)
	WEND
END SUB

SUB SENDCTRLC
	PRINT #1, CHR$(3);
	CALL DELAY(50)
	WHILE LOC(1) > 0
		SCIN$ = INPUT$(1, #1)
		PRINT SCIN$;
	WEND
END SUB

